---
generated_at: 2026-02-01 10:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：1-ac - 接続時間アカウンティングレポート

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **cronジョブでの定期実行**：実装上の根拠なし（一般的なUNIXの使い方として記載）

## 2) 参照した情報（Evidence一覧）

- E-01: `usr.sbin/ac/ac.c` 49-76行目（データ構造体定義）
- E-02: `usr.sbin/ac/ac.c` 204-253行目（main関数、オプション解析）
- E-03: `usr.sbin/ac/ac.c` 402-507行目（ac関数、メイン処理ループ）
- E-04: `usr.sbin/ac/ac.c` 259-308行目（show, show_users, show_today出力関数）
- E-05: `usr.sbin/ac/ac.c` 315-341行目（log_out関数）
- E-06: `usr.sbin/ac/ac.c` 346-400行目（log_in関数）
- E-07: `usr.sbin/ac/ac.c` 170-202行目（update_user関数）
- E-08: `usr.sbin/ac/ac.c` 100-124行目（add_tty関数）
- E-09: `usr.sbin/ac/ac.c` 129-147行目（do_tty関数）
- E-10: `usr.sbin/ac/ac.c` 509-519行目（usage関数）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | utmpxログファイルを読み取りユーザー接続時間を集計する | E-03 (415行目 setutxdb, 417行目 getutxent) | ○ |
| C-02 | -dオプションで日別出力、-pオプションでユーザー別出力 | E-02 (221-228行目), E-04 | ○ |
| C-03 | -dと-pは排他的 | E-02 (249-250行目: `Flags &= ~AC_P`) | ○ |
| C-04 | ユーザー名はアルファベット順にソートされる | E-07 (177-186行目: strcmp比較で挿入ソート) | ○ |
| C-05 | 接続時間は小数点以下2桁の時間単位で表示 | E-04 (262行目: `%8.2f`, `(double)secs.tv_sec / 3600`) | ○ |
| C-06 | 3つの構造体(utmpx_entry, user_entry, tty_entry)をSLISTで管理 | E-01 (49-76行目) | ○ |
| C-07 | pts接続でut_hostが空の場合はログインとして記録しない | E-03 (464-466行目) | ○ |
| C-08 | BOOT_TIME/SHUTDOWN_TIMEで全セッション終了 | E-05 (322行目の条件分岐) | ○ |
| C-09 | OLD_TIME/NEW_TIMEで時計変更補正を行う | E-03 (443-452行目) | ○ |
| C-10 | -wオプションで任意wtmpファイルを指定可能 | E-02 (230-232行目) | ○ |
| C-11 | -tオプションでTTYフィルタリング可能 | E-08, E-09 | ○ |
| C-12 | メモリ確保失敗時にerrx(1, "malloc failed")を出力 | E-06 (391行目), E-07 (193行目) | ○ |
| C-13 | setutxdb失敗時にerr(1)を出力 | E-03 (416行目) | ○ |
| C-14 | ロケール設定(LC_TIME)に従う | E-02 (210行目: setlocale(LC_TIME, "")) | ○ |
| C-15 | 日付フォーマットはd_firstフラグにより月日/日月が切り替わる | E-04 (288-292行目) | ○ |
| C-16 | 全処理が単一ファイル(ac.c)に集約 | E-01~E-10（全てac.c内） | ○ |
| C-17 | -cオプションでコンソールデバイスを指定可能 | E-02 (215-219行目: CONSOLE_TTY条件付き) | ○ |
| C-18 | cronジョブでの定期実行が可能 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- cronジョブでの定期実行に関する記載は一般的なUNIXの知識に基づくもので、ac.c内に直接の根拠はない
  - 候補：manページ / 運用マニュアル / crontab設定例

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードが単一ファイルで完結しており、処理の追跡が容易

## 6) レビュアーチェックリスト（最小）
- [ ] CONSOLE_TTYマクロの有効/無効によるビルド時の挙動差異を確認
- [ ] wtmpxファイルフォーマットのバージョン互換性を確認
- [ ] show_today関数での日付境界処理（タイムゾーン考慮）の妥当性を確認
